/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.util;

import it.businesslogic.ireport.Band;
import it.businesslogic.ireport.Group;
import it.businesslogic.ireport.JRField;
import it.businesslogic.ireport.Report;
import it.businesslogic.ireport.ReportElement;
import it.businesslogic.ireport.StaticTextReportElement;
import it.businesslogic.ireport.SubDataset;
import it.businesslogic.ireport.TextFieldReportElement;
import it.businesslogic.ireport.TransformationType;
import it.businesslogic.ireport.gui.wizard.UserChoicesWizardTemplate;
import it.businesslogic.ireport.util.Misc;
import java.awt.Point;
import java.util.Enumeration;
import java.util.Vector;

public class ReportGenerator {
    public static Report createReport(UserChoicesWizardTemplate ucwt) throws Exception {
        if (ucwt.getTemplateFile().toUpperCase().endsWith("C.XML")) {
            return ReportGenerator.createColumnarReport(ucwt);
        }
        return ReportGenerator.createTabularReport(ucwt);
    }

    public static Report createColumnarReport(UserChoicesWizardTemplate ucwt) throws Exception {
        JRField f;
        int i;
        String fclass;
        String fname;
        TextFieldReportElement tfre;
        StaticTextReportElement stre;
        ReportElement rElement;
        Group g;
        Report template = new Report(ucwt.getTemplateFile());
        template.incrementReportChanges();
        template.setFilename(null);
        Band detail = null;
        Band columns = null;
        Enumeration e = template.getBands().elements();
        while (e.hasMoreElements()) {
            Band band = (Band)e.nextElement();
            if (band.getName().equals("detail")) {
                detail = band;
                continue;
            }
            if (!band.getName().equals("columnHeader")) continue;
            columns = band;
        }
        e = template.getElements().elements();
        while (e.hasMoreElements()) {
            ReportElement rElement2 = (ReportElement)((Object)e.nextElement());
            rElement2.trasform(new Point(0, -template.getBandYLocation(rElement2.getBand())), TransformationType.TRANSFORMATION_MOVE);
        }
        if (ucwt.getGroupExpressions().size() > 0) {
            g = template.getGroupByName("Group1");
            Group g1 = new Group((SubDataset)template, Misc.string_replace("_", " ", "" + ucwt.getGroupExpressions().get(0)), g.getGroupFooter().getHeight(), g.getGroupHeader().getHeight());
            g1.setGroupExpression("$F{" + ucwt.getGroupExpressions().get(0) + "}");
            template.addGroup(g1);
            e = template.getElements().elements();
            while (e.hasMoreElements()) {
                rElement = (ReportElement)((Object)e.nextElement());
                if (rElement.getBand() == g.getGroupHeader()) {
                    rElement.setBand(g1.getGroupHeader());
                } else if (rElement.getBand() == g.getGroupFooter()) {
                    rElement.setBand(g1.getGroupFooter());
                }
                if (rElement instanceof StaticTextReportElement) {
                    stre = (StaticTextReportElement)rElement;
                    if (!stre.getText().equals("G1Label")) continue;
                    stre.setText("" + ucwt.getGroupExpressions().get(0));
                    continue;
                }
                if (!(rElement instanceof TextFieldReportElement) || !(tfre = (TextFieldReportElement)rElement).getText().equals("G1Field")) continue;
                tfre.setText("$F{" + ucwt.getGroupExpressions().get(0) + "}");
                fname = "" + ucwt.getGroupExpressions().get(0);
                fclass = "java.lang.String";
                for (i = 0; i < ucwt.getDisplayFields().size(); ++i) {
                    f = (JRField)ucwt.getDisplayFields().get(i);
                    if (!f.getName().equals(fname)) continue;
                    fclass = f.getClassType();
                    break;
                }
                tfre.setMatchingClassExpression(fclass, true);
            }
        }
        if (ucwt.getGroupExpressions().size() > 1) {
            g = template.getGroupByName("Group2");
            Group g2 = new Group((SubDataset)template, Misc.string_replace("_", " ", "" + ucwt.getGroupExpressions().get(1)), g.getGroupFooter().getHeight(), g.getGroupHeader().getHeight());
            g2.setGroupExpression("$F{" + ucwt.getGroupExpressions().get(1) + "}");
            template.addGroup(g2);
            e = template.getElements().elements();
            while (e.hasMoreElements()) {
                rElement = (ReportElement)((Object)e.nextElement());
                if (rElement.getBand() == g.getGroupHeader()) {
                    rElement.setBand(g2.getGroupHeader());
                } else if (rElement.getBand() == g.getGroupFooter()) {
                    rElement.setBand(g2.getGroupFooter());
                }
                if (rElement instanceof StaticTextReportElement) {
                    stre = (StaticTextReportElement)rElement;
                    if (!stre.getText().equals("G2Label")) continue;
                    stre.setText("" + ucwt.getGroupExpressions().get(1));
                    continue;
                }
                if (!(rElement instanceof TextFieldReportElement) || !(tfre = (TextFieldReportElement)rElement).getText().equals("G2Field")) continue;
                tfre.setText("$F{" + ucwt.getGroupExpressions().get(1) + "}");
                fname = "" + ucwt.getGroupExpressions().get(1);
                fclass = "java.lang.String";
                for (i = 0; i < ucwt.getDisplayFields().size(); ++i) {
                    f = (JRField)ucwt.getDisplayFields().get(i);
                    if (!f.getName().equals(fname)) continue;
                    fclass = f.getClassType();
                    break;
                }
                tfre.setMatchingClassExpression(fclass, true);
            }
        }
        if (ucwt.getGroupExpressions().size() > 2) {
            g = template.getGroupByName("Group3");
            Group g3 = new Group((SubDataset)template, Misc.string_replace("_", " ", "" + ucwt.getGroupExpressions().get(2)), g.getGroupFooter().getHeight(), g.getGroupHeader().getHeight());
            g3.setGroupExpression("$F{" + ucwt.getGroupExpressions().get(2) + "}");
            template.addGroup(g3);
            e = template.getElements().elements();
            while (e.hasMoreElements()) {
                rElement = (ReportElement)((Object)e.nextElement());
                if (rElement.getBand() == g.getGroupHeader()) {
                    rElement.setBand(g3.getGroupHeader());
                } else if (rElement.getBand() == g.getGroupFooter()) {
                    rElement.setBand(g3.getGroupFooter());
                }
                if (rElement instanceof StaticTextReportElement) {
                    stre = (StaticTextReportElement)rElement;
                    if (!stre.getText().equals("G3Label")) continue;
                    stre.setText("" + ucwt.getGroupExpressions().get(2));
                    continue;
                }
                if (!(rElement instanceof TextFieldReportElement) || !(tfre = (TextFieldReportElement)rElement).getText().equals("G3Field")) continue;
                tfre.setText("$F{" + ucwt.getGroupExpressions().get(2) + "}");
                fname = "" + ucwt.getGroupExpressions().get(2);
                fclass = "java.lang.String";
                for (i = 0; i < ucwt.getDisplayFields().size(); ++i) {
                    f = (JRField)ucwt.getDisplayFields().get(i);
                    if (!f.getName().equals(fname)) continue;
                    fclass = f.getClassType();
                    break;
                }
                tfre.setMatchingClassExpression(fclass, true);
            }
        }
        if (ucwt.getGroupExpressions().size() > 3) {
            g = template.getGroupByName("Group4");
            Group g4 = new Group((SubDataset)template, Misc.string_replace("_", " ", "" + ucwt.getGroupExpressions().get(3)), g.getGroupFooter().getHeight(), g.getGroupHeader().getHeight());
            g4.setGroupExpression("$F{" + ucwt.getGroupExpressions().get(3) + "}");
            template.addGroup(g4);
            e = template.getElements().elements();
            while (e.hasMoreElements()) {
                rElement = (ReportElement)((Object)e.nextElement());
                if (rElement.getBand() == g.getGroupHeader()) {
                    rElement.setBand(g4.getGroupHeader());
                } else if (rElement.getBand() == g.getGroupFooter()) {
                    rElement.setBand(g4.getGroupFooter());
                }
                if (rElement instanceof StaticTextReportElement) {
                    stre = (StaticTextReportElement)rElement;
                    if (!stre.getText().equals("G4Label")) continue;
                    stre.setText("" + ucwt.getGroupExpressions().get(3));
                    continue;
                }
                if (!(rElement instanceof TextFieldReportElement) || !(tfre = (TextFieldReportElement)rElement).getText().equals("G4Field")) continue;
                tfre.setText("$F{" + ucwt.getGroupExpressions().get(3) + "}");
                fname = "" + ucwt.getGroupExpressions().get(3);
                fclass = "java.lang.String";
                for (i = 0; i < ucwt.getDisplayFields().size(); ++i) {
                    f = (JRField)ucwt.getDisplayFields().get(i);
                    if (!f.getName().equals(fname)) continue;
                    fclass = f.getClassType();
                    break;
                }
                tfre.setMatchingClassExpression(fclass, true);
            }
        }
        int currentx = template.getLeftMargin() + 10;
        int currenty = 10;
        e = template.getElements().elements();
        StaticTextReportElement detailLabel = null;
        TextFieldReportElement detailField = null;
        while (e.hasMoreElements() && (detailLabel == null || detailField == null)) {
            TextFieldReportElement tfre2;
            ReportElement rElement3 = (ReportElement)((Object)e.nextElement());
            if (rElement3 instanceof StaticTextReportElement) {
                StaticTextReportElement stre2 = (StaticTextReportElement)rElement3;
                if (!stre2.getText().equalsIgnoreCase("DetailLabel")) continue;
                detailLabel = stre2;
                continue;
            }
            if (!(rElement3 instanceof TextFieldReportElement) || !(tfre2 = (TextFieldReportElement)rElement3).getText().equalsIgnoreCase("DetailField")) continue;
            detailField = tfre2;
        }
        if (detailField != null) {
            template.getElements().removeElement(detailField);
        }
        if (detailLabel != null) {
            template.getElements().removeElement(detailLabel);
        }
        if (detailField == null) {
            detailField = new TextFieldReportElement(0, 0, 100, 20);
        }
        if (detailLabel == null) {
            detailLabel = new StaticTextReportElement(0, 0, 100, 18);
        }
        int nfields = ucwt.getDisplayFields().size();
        if (ucwt.getGroupExpressions().size() > 0) {
            --nfields;
        }
        if (ucwt.getGroupExpressions().size() > 1) {
            --nfields;
        }
        if (ucwt.getGroupExpressions().size() > 2) {
            --nfields;
        }
        if (ucwt.getGroupExpressions().size() > 3) {
            --nfields;
        }
        int fwidth = template.getColumnWidth() / (nfields <= 0 ? 1 : nfields);
        int ffheight = detailField.getPosition().y;
        for (int i2 = 0; i2 < ucwt.getDisplayFields().size(); ++i2) {
            String description;
            JRField f2 = (JRField)ucwt.getDisplayFields().get(i2);
            template.addField(f2);
            if (ucwt.getGroupExpressions().size() > 0 && f2.getName().equalsIgnoreCase("" + ucwt.getGroupExpressions().get(0)) || ucwt.getGroupExpressions().size() > 1 && f2.getName().equalsIgnoreCase("" + ucwt.getGroupExpressions().get(1)) || ucwt.getGroupExpressions().size() > 2 && f2.getName().equalsIgnoreCase("" + ucwt.getGroupExpressions().get(2)) || ucwt.getGroupExpressions().size() > 3 && f2.getName().equalsIgnoreCase("" + ucwt.getGroupExpressions().get(3))) continue;
            TextFieldReportElement re = (TextFieldReportElement)detailField.cloneMe();
            re.setPosition(new Point(detailField.getPosition().x, ffheight));
            re.updateBounds();
            re.setText("$F{" + f2.getName() + "}");
            re.setBand(detail);
            re.setMatchingClassExpression(f2.getClassType(), true);
            template.getElements().addElement(re);
            StaticTextReportElement sre = (StaticTextReportElement)detailLabel.cloneMe();
            sre.setPosition(new Point(detailLabel.getPosition().x, ffheight));
            sre.setWidth(fwidth);
            sre.updateBounds();
            String columnLabelText = f2.getName();
            if (ucwt.isSaveFieldDescriptions() && (description = f2.getDescription()) != null && description.length() > 0) {
                columnLabelText = description;
            }
            sre.setText("" + columnLabelText + "");
            sre.setBand(detail);
            template.getElements().addElement(sre);
            ffheight += detailField.position.y + detailField.height - 10;
        }
        detail.setHeight(ffheight);
        e = template.getElements().elements();
        Vector<ReportElement> elements_to_delete = new Vector<ReportElement>();
        while (e.hasMoreElements()) {
            ReportElement rElement4 = (ReportElement)((Object)e.nextElement());
            Group g2 = null;
            g2 = template.getGroupByName("Group1");
            if (g2 != null && (rElement4.getBand() == g2.getGroupHeader() || rElement4.getBand() == g2.getGroupFooter())) {
                elements_to_delete.addElement(rElement4);
                continue;
            }
            g2 = template.getGroupByName("Group2");
            if (g2 != null && (rElement4.getBand() == g2.getGroupHeader() || rElement4.getBand() == g2.getGroupFooter())) {
                elements_to_delete.addElement(rElement4);
                continue;
            }
            g2 = template.getGroupByName("Group3");
            if (g2 != null && (rElement4.getBand() == g2.getGroupHeader() || rElement4.getBand() == g2.getGroupFooter())) {
                elements_to_delete.addElement(rElement4);
                continue;
            }
            g2 = template.getGroupByName("Group4");
            if (g2 == null || rElement4.getBand() != g2.getGroupHeader() && rElement4.getBand() != g2.getGroupFooter()) continue;
            elements_to_delete.addElement(rElement4);
        }
        e = elements_to_delete.elements();
        while (e.hasMoreElements()) {
            template.getElements().removeElement(e.nextElement());
        }
        Group g3 = template.getGroupByName("Group1");
        if (g3 != null) {
            template.getBands().removeElement(g3.getGroupFooter());
            template.getBands().removeElement(g3.getGroupHeader());
            template.getGroups().removeElement(g3);
        }
        if ((g3 = template.getGroupByName("Group2")) != null) {
            template.getBands().removeElement(g3.getGroupFooter());
            template.getBands().removeElement(g3.getGroupHeader());
            template.getGroups().removeElement(g3);
        }
        if ((g3 = template.getGroupByName("Group3")) != null) {
            template.getBands().removeElement(g3.getGroupFooter());
            template.getBands().removeElement(g3.getGroupHeader());
            template.getGroups().removeElement(g3);
        }
        if ((g3 = template.getGroupByName("Group4")) != null) {
            template.getBands().removeElement(g3.getGroupFooter());
            template.getBands().removeElement(g3.getGroupHeader());
            template.getGroups().removeElement(g3);
        }
        e = template.getElements().elements();
        while (e.hasMoreElements()) {
            ReportElement rElement5 = (ReportElement)((Object)e.nextElement());
            rElement5.trasform(new Point(0, template.getBandYLocation(rElement5.getBand())), TransformationType.TRANSFORMATION_MOVE);
        }
        template.setQuery(ucwt.getQuery());
        template.setQueryLanguage(ucwt.getQuery_language());
        return template;
    }

    public static Report createTabularReport(UserChoicesWizardTemplate ucwt) throws Exception {
        JRField f;
        int i;
        String fclass;
        String fname;
        TextFieldReportElement tfre;
        StaticTextReportElement stre;
        ReportElement rElement;
        Group g;
        Report template = new Report(ucwt.getTemplateFile());
        template.incrementReportChanges();
        template.setFilename(null);
        Band detail = null;
        Band columns = null;
        Enumeration e = template.getBands().elements();
        while (e.hasMoreElements()) {
            Band band = (Band)e.nextElement();
            if (band.getName().equals("detail")) {
                detail = band;
                continue;
            }
            if (!band.getName().equals("columnHeader")) continue;
            columns = band;
        }
        e = template.getElements().elements();
        while (e.hasMoreElements()) {
            ReportElement rElement2 = (ReportElement)((Object)e.nextElement());
            rElement2.trasform(new Point(0, -template.getBandYLocation(rElement2.getBand())), TransformationType.TRANSFORMATION_MOVE);
        }
        if (ucwt.getGroupExpressions().size() > 0) {
            g = template.getGroupByName("Group1");
            Group g1 = new Group((SubDataset)template, Misc.string_replace("_", " ", "" + ucwt.getGroupExpressions().get(0)), g.getGroupFooter().getHeight(), g.getGroupHeader().getHeight());
            g1.setGroupExpression("$F{" + ucwt.getGroupExpressions().get(0) + "}");
            template.addGroup(g1);
            e = template.getElements().elements();
            while (e.hasMoreElements()) {
                rElement = (ReportElement)((Object)e.nextElement());
                if (rElement.getBand() == g.getGroupHeader()) {
                    rElement.setBand(g1.getGroupHeader());
                } else if (rElement.getBand() == g.getGroupFooter()) {
                    rElement.setBand(g1.getGroupFooter());
                }
                if (rElement instanceof StaticTextReportElement) {
                    stre = (StaticTextReportElement)rElement;
                    if (!stre.getText().equals("G1Label")) continue;
                    stre.setText("" + ucwt.getGroupExpressions().get(0));
                    continue;
                }
                if (!(rElement instanceof TextFieldReportElement) || !(tfre = (TextFieldReportElement)rElement).getText().equals("G1Field")) continue;
                tfre.setText("$F{" + ucwt.getGroupExpressions().get(0) + "}");
                fname = "" + ucwt.getGroupExpressions().get(0);
                fclass = "java.lang.String";
                for (i = 0; i < ucwt.getDisplayFields().size(); ++i) {
                    f = (JRField)ucwt.getDisplayFields().get(i);
                    if (!f.getName().equals(fname)) continue;
                    fclass = f.getClassType();
                    break;
                }
                tfre.setMatchingClassExpression(fclass, true);
            }
        }
        if (ucwt.getGroupExpressions().size() > 1) {
            g = template.getGroupByName("Group2");
            Group g2 = new Group((SubDataset)template, Misc.string_replace("_", " ", "" + ucwt.getGroupExpressions().get(1)), g.getGroupFooter().getHeight(), g.getGroupHeader().getHeight());
            g2.setGroupExpression("$F{" + ucwt.getGroupExpressions().get(1) + "}");
            template.addGroup(g2);
            e = template.getElements().elements();
            while (e.hasMoreElements()) {
                rElement = (ReportElement)((Object)e.nextElement());
                if (rElement.getBand() == g.getGroupHeader()) {
                    rElement.setBand(g2.getGroupHeader());
                } else if (rElement.getBand() == g.getGroupFooter()) {
                    rElement.setBand(g2.getGroupFooter());
                }
                if (rElement instanceof StaticTextReportElement) {
                    stre = (StaticTextReportElement)rElement;
                    if (!stre.getText().equals("G2Label")) continue;
                    stre.setText("" + ucwt.getGroupExpressions().get(1));
                    continue;
                }
                if (!(rElement instanceof TextFieldReportElement) || !(tfre = (TextFieldReportElement)rElement).getText().equals("G2Field")) continue;
                tfre.setText("$F{" + ucwt.getGroupExpressions().get(1) + "}");
                fname = "" + ucwt.getGroupExpressions().get(1);
                fclass = "java.lang.String";
                for (i = 0; i < ucwt.getDisplayFields().size(); ++i) {
                    f = (JRField)ucwt.getDisplayFields().get(i);
                    if (!f.getName().equals(fname)) continue;
                    fclass = f.getClassType();
                    break;
                }
                tfre.setMatchingClassExpression(fclass, true);
            }
        }
        if (ucwt.getGroupExpressions().size() > 2) {
            g = template.getGroupByName("Group3");
            Group g3 = new Group((SubDataset)template, Misc.string_replace("_", " ", "" + ucwt.getGroupExpressions().get(2)), g.getGroupFooter().getHeight(), g.getGroupHeader().getHeight());
            g3.setGroupExpression("$F{" + ucwt.getGroupExpressions().get(2) + "}");
            template.addGroup(g3);
            e = template.getElements().elements();
            while (e.hasMoreElements()) {
                rElement = (ReportElement)((Object)e.nextElement());
                if (rElement.getBand() == g.getGroupHeader()) {
                    rElement.setBand(g3.getGroupHeader());
                } else if (rElement.getBand() == g.getGroupFooter()) {
                    rElement.setBand(g3.getGroupFooter());
                }
                if (rElement instanceof StaticTextReportElement) {
                    stre = (StaticTextReportElement)rElement;
                    if (!stre.getText().equals("G3Label")) continue;
                    stre.setText("" + ucwt.getGroupExpressions().get(2));
                    continue;
                }
                if (!(rElement instanceof TextFieldReportElement) || !(tfre = (TextFieldReportElement)rElement).getText().equals("G3Field")) continue;
                tfre.setText("$F{" + ucwt.getGroupExpressions().get(2) + "}");
                fname = "" + ucwt.getGroupExpressions().get(2);
                fclass = "java.lang.String";
                for (i = 0; i < ucwt.getDisplayFields().size(); ++i) {
                    f = (JRField)ucwt.getDisplayFields().get(i);
                    if (!f.getName().equals(fname)) continue;
                    fclass = f.getClassType();
                    break;
                }
                tfre.setMatchingClassExpression(fclass, true);
            }
        }
        if (ucwt.getGroupExpressions().size() > 3) {
            g = template.getGroupByName("Group4");
            Group g4 = new Group((SubDataset)template, Misc.string_replace("_", " ", "" + ucwt.getGroupExpressions().get(3)), g.getGroupFooter().getHeight(), g.getGroupHeader().getHeight());
            g4.setGroupExpression("$F{" + ucwt.getGroupExpressions().get(3) + "}");
            template.addGroup(g4);
            e = template.getElements().elements();
            while (e.hasMoreElements()) {
                rElement = (ReportElement)((Object)e.nextElement());
                if (rElement.getBand() == g.getGroupHeader()) {
                    rElement.setBand(g4.getGroupHeader());
                } else if (rElement.getBand() == g.getGroupFooter()) {
                    rElement.setBand(g4.getGroupFooter());
                }
                if (rElement instanceof StaticTextReportElement) {
                    stre = (StaticTextReportElement)rElement;
                    if (!stre.getText().equals("G4Label")) continue;
                    stre.setText("" + ucwt.getGroupExpressions().get(3));
                    continue;
                }
                if (!(rElement instanceof TextFieldReportElement) || !(tfre = (TextFieldReportElement)rElement).getText().equals("G4Field")) continue;
                tfre.setText("$F{" + ucwt.getGroupExpressions().get(3) + "}");
                fname = "" + ucwt.getGroupExpressions().get(3);
                fclass = "java.lang.String";
                for (i = 0; i < ucwt.getDisplayFields().size(); ++i) {
                    f = (JRField)ucwt.getDisplayFields().get(i);
                    if (!f.getName().equals(fname)) continue;
                    fclass = f.getClassType();
                    break;
                }
                tfre.setMatchingClassExpression(fclass, true);
            }
        }
        int currentx = template.getLeftMargin() + 10;
        int currenty = 10;
        e = template.getElements().elements();
        StaticTextReportElement detailLabel = null;
        TextFieldReportElement detailField = null;
        while (e.hasMoreElements() && (detailLabel == null || detailField == null)) {
            TextFieldReportElement tfre2;
            ReportElement rElement3 = (ReportElement)((Object)e.nextElement());
            if (rElement3 instanceof StaticTextReportElement) {
                StaticTextReportElement stre2 = (StaticTextReportElement)rElement3;
                if (!stre2.getText().equalsIgnoreCase("DetailLabel")) continue;
                detailLabel = stre2;
                continue;
            }
            if (!(rElement3 instanceof TextFieldReportElement) || !(tfre2 = (TextFieldReportElement)rElement3).getText().equalsIgnoreCase("DetailField")) continue;
            detailField = tfre2;
        }
        if (detailField != null) {
            template.getElements().removeElement(detailField);
        }
        if (detailLabel != null) {
            template.getElements().removeElement(detailLabel);
        }
        if (detailField == null) {
            detailField = new TextFieldReportElement(0, 0, 100, 20);
        }
        if (detailLabel == null) {
            detailLabel = new StaticTextReportElement(0, 0, 100, 18);
        }
        int nfields = ucwt.getDisplayFields().size();
        if (ucwt.getGroupExpressions().size() > 0) {
            --nfields;
        }
        if (ucwt.getGroupExpressions().size() > 1) {
            --nfields;
        }
        if (ucwt.getGroupExpressions().size() > 2) {
            --nfields;
        }
        if (ucwt.getGroupExpressions().size() > 3) {
            --nfields;
        }
        int fwidth = template.getColumnWidth() / (nfields <= 0 ? 1 : nfields);
        for (i = 0; i < ucwt.getDisplayFields().size(); ++i) {
            String description;
            f = (JRField)ucwt.getDisplayFields().get(i);
            template.addField(f);
            if (ucwt.getGroupExpressions().size() > 0 && f.getName().equalsIgnoreCase("" + ucwt.getGroupExpressions().get(0)) || ucwt.getGroupExpressions().size() > 1 && f.getName().equalsIgnoreCase("" + ucwt.getGroupExpressions().get(1)) || ucwt.getGroupExpressions().size() > 2 && f.getName().equalsIgnoreCase("" + ucwt.getGroupExpressions().get(2)) || ucwt.getGroupExpressions().size() > 3 && f.getName().equalsIgnoreCase("" + ucwt.getGroupExpressions().get(3))) continue;
            TextFieldReportElement re = (TextFieldReportElement)detailField.cloneMe();
            re.setPosition(new Point(currentx, detailField.getPosition().y));
            re.setWidth(fwidth);
            re.updateBounds();
            re.setText("$F{" + f.getName() + "}");
            re.setBand(detail);
            re.setMatchingClassExpression(f.getClassType(), true);
            template.getElements().addElement(re);
            StaticTextReportElement sre = (StaticTextReportElement)detailLabel.cloneMe();
            sre.setPosition(new Point(currentx, detailLabel.getPosition().y));
            sre.setWidth(fwidth);
            sre.updateBounds();
            String columnLabelText = f.getName();
            if (ucwt.isSaveFieldDescriptions() && (description = f.getDescription()) != null && description.length() > 0) {
                columnLabelText = description;
            }
            sre.setText("" + columnLabelText + "");
            sre.setBand(columns);
            template.getElements().addElement(sre);
            currentx += fwidth;
            currentx = Math.min(template.getWidth() - template.getRightMargin() + 10 - 30, currentx);
        }
        e = template.getElements().elements();
        Vector<ReportElement> elements_to_delete = new Vector<ReportElement>();
        while (e.hasMoreElements()) {
            ReportElement rElement4 = (ReportElement)((Object)e.nextElement());
            Group g2 = null;
            g2 = template.getGroupByName("Group1");
            if (g2 != null && (rElement4.getBand() == g2.getGroupHeader() || rElement4.getBand() == g2.getGroupFooter())) {
                elements_to_delete.addElement(rElement4);
                continue;
            }
            g2 = template.getGroupByName("Group2");
            if (g2 != null && (rElement4.getBand() == g2.getGroupHeader() || rElement4.getBand() == g2.getGroupFooter())) {
                elements_to_delete.addElement(rElement4);
                continue;
            }
            g2 = template.getGroupByName("Group3");
            if (g2 != null && (rElement4.getBand() == g2.getGroupHeader() || rElement4.getBand() == g2.getGroupFooter())) {
                elements_to_delete.addElement(rElement4);
                continue;
            }
            g2 = template.getGroupByName("Group4");
            if (g2 == null || rElement4.getBand() != g2.getGroupHeader() && rElement4.getBand() != g2.getGroupFooter()) continue;
            elements_to_delete.addElement(rElement4);
        }
        e = elements_to_delete.elements();
        while (e.hasMoreElements()) {
            template.getElements().removeElement(e.nextElement());
        }
        Group g3 = template.getGroupByName("Group1");
        if (g3 != null) {
            template.getBands().removeElement(g3.getGroupFooter());
            template.getBands().removeElement(g3.getGroupHeader());
            template.getGroups().removeElement(g3);
        }
        if ((g3 = template.getGroupByName("Group2")) != null) {
            template.getBands().removeElement(g3.getGroupFooter());
            template.getBands().removeElement(g3.getGroupHeader());
            template.getGroups().removeElement(g3);
        }
        if ((g3 = template.getGroupByName("Group3")) != null) {
            template.getBands().removeElement(g3.getGroupFooter());
            template.getBands().removeElement(g3.getGroupHeader());
            template.getGroups().removeElement(g3);
        }
        if ((g3 = template.getGroupByName("Group4")) != null) {
            template.getBands().removeElement(g3.getGroupFooter());
            template.getBands().removeElement(g3.getGroupHeader());
            template.getGroups().removeElement(g3);
        }
        e = template.getElements().elements();
        while (e.hasMoreElements()) {
            ReportElement rElement5 = (ReportElement)((Object)e.nextElement());
            rElement5.trasform(new Point(0, template.getBandYLocation(rElement5.getBand())), TransformationType.TRANSFORMATION_MOVE);
        }
        template.setQuery(ucwt.getQuery());
        template.setQueryLanguage(ucwt.getQuery_language());
        return template;
    }
}

