package ni.bagsa.process;

import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.util.List;

import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MClient;
import org.compiere.model.MMailText;
import org.compiere.model.MNicProcessCaller;
import org.compiere.model.MProcess;
import org.compiere.model.MSysConfig;
import org.compiere.model.MUser;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfo;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Env;



/**
 * Se crea proceso para ejecutar proceso programados
 * @author Alex Gaitan
 * @since 2023-03-17
 *
 */
public class NicCallScheduledProcess extends SvrProcess{

	@Override
	protected void prepare() {
		
		// TODO Auto-generated method stub
		
	}

	@Override
	protected String doIt() throws Exception {
		
		
		/**
		 * Verificando que solo se ejecute desde el servidor local de
		 * producccion
		 */
		InetAddress ip = InetAddress.getLocalHost();

		String hostname = ip.getHostAddress();
		String nameServe = getValueFromConfig("SERVER_LOCAL_IP_PROCESSCALLER");

		log.info(hostname);
		
		if (!hostname.equals(nameServe)) {
			log.info("El proceso no se ejecutó debido a que el ip de la instancia de adempiere no es la configurada en SERVER_LOCAL_IP_PROCESSCALLER");
			
			return "El proceso no se ejecutó debido a que el ip de la instancia de adempiere no es la configurada en SERVER_LOCAL_IP_PROCESSCALLER";
		}
		
		/**
		 * Fin validación
		 */
		
		
		StringBuilder message = new StringBuilder();
		
		String processCallerWhere = String.format("%s = 'Y' and %s = ?", MNicProcessCaller.COLUMNNAME_IsActive, MNicProcessCaller.COLUMNNAME_Status);
		
		
		List<MNicProcessCaller> processesToCall = 
				new Query(this.getCtx(), MNicProcessCaller.Table_Name, processCallerWhere,null)
				.setParameters(MNicProcessCaller.STATUS_Requested)
				.list();
		
		
		String processStr = "-None-";
		
		
		for (MNicProcessCaller mNicProcessCaller : processesToCall) {
			message.append("**** Scheduled process caller is starting ****");
			
			log.info("**** Scheduled process caller is starting ****");
			String processQuery = String.format("%s = ?", MProcess.COLUMNNAME_AD_Process_ID);

			
			MProcess process = new Query(this.getCtx(), MProcess.Table_Name, processQuery, null)
					.setParameters(mNicProcessCaller.getAD_Process_ID())
					.first();
			
			processStr = mNicProcessCaller.getDescription();
			
			if (process == null) {
				log.severe("Proceso agendado no fue encontrado");
				throw new AdempiereException("Proceso agendado no fue encontrado");
			}
			

			int tableID = mNicProcessCaller.get_Table_ID();
			int recordID = mNicProcessCaller.getRecord_ID();
			int userID = mNicProcessCaller.getAD_User_ID();
			
			String logStr = String.format("Calling to -> %s [tableId, recordId, userId] = [%d,%d,%d] ", this.getName(), tableID, recordID, userID);
			
			message.append(logStr);
			log.info(logStr);
			
			try 
			{
				/**
				 * @author Alex Gaitan
				 * @since 2023-06-07
				 */

				this.getCtx().setProperty("#AD_User_ID", String.valueOf(userID));
				this.getCtx().setProperty("#AD_Client_ID", String.valueOf(mNicProcessCaller.getAD_Client_ID()));
				this.getCtx().setProperty("#AD_Org_ID", String.valueOf(mNicProcessCaller.getAD_Org_ID()));
				
				String className = process.getClassname();
				
				ProcessInfo processInfo = new ProcessInfo("Automatic", process.get_ID(),tableID, recordID);
				
				Class<?> clazz = Class.forName(className);
				Constructor<?> ctor = clazz.getConstructor();
				
				
				SvrProcess processToCall = (SvrProcess) ctor.newInstance(new Object[] {  });
				
				processToCall.startProcess(this.getCtx(), processInfo, null);
				
				
				if (processInfo.isError()) {
					mNicProcessCaller.setStatus(MNicProcessCaller.STATUS_Failed);
				}
				else {
					mNicProcessCaller.setStatus(MNicProcessCaller.STATUS_Success);	
				}
				
				mNicProcessCaller.setSummary(processInfo.getSummary());
				
				mNicProcessCaller.saveEx();
			
				String queryEmailTemplate = String.format("%s = ?",MMailText.COLUMNNAME_Name);
				
				MMailText mail = new Query(Env.getCtx(), MMailText.Table_Name, queryEmailTemplate, null)
						.setParameters("AUTO_PROCESS_CALLER_TEMPLATE") // PASSWORD RESET TEMPLATE
						.first();
				
				StringBuilder bodyTemplate = new StringBuilder();
				
				if (mail.get_Value(MMailText.COLUMNNAME_MailText) != null)
					bodyTemplate.append(mail.getMailText());
				if (mail.get_Value(MMailText.COLUMNNAME_MailText2) != null)
					bodyTemplate.append(mail.getMailText2());			
				if (mail.get_Value(MMailText.COLUMNNAME_MailText3) != null)
					bodyTemplate.append(mail.getMailText3());
				

				String body = bodyTemplate.toString().replace("@body", processStr.concat(" - ").concat(processInfo.getSummary()));
			
				MUser user = MUser.get(Env.getCtx(), mNicProcessCaller.getAD_User_ID());
				
				sendProcessCompletedEmail(user, mNicProcessCaller.getStatus(), body);
			} catch(Exception e) {
				// rollback current.
				this.rollback();
				

				mNicProcessCaller.setSummary(e.toString());
				mNicProcessCaller.setStatus(MNicProcessCaller.STATUS_Failed);
				mNicProcessCaller.saveEx();
				
				String adminEmail = getValueFromConfig("ADMIN_EMAIL");
				MClient client = MClient.get(Env.getCtx(), this.getAD_Client_ID());
				
				
				String emailMessage = processStr.concat(" - ").concat(e.getMessage());
				
				sendProcessCompletedEmail(client,adminEmail, MNicProcessCaller.STATUS_Failed, emailMessage);
				
				log.severe(String.format("Failed -> %s", e.getMessage()));
			}
			finally {
				this.commitEx();
			}
			// commit by every process call
			
			message.append("**** Scheduled process caller has finished ****");
			log.info("**** Scheduled process caller has finished ****");
			
			return message.toString();
		}
		
		
		return null;
	}
	
	
	private void sendProcessCompletedEmail(MUser user, String status, String message) {
		
		MClient client = MClient.get(Env.getCtx(),user.getAD_Client_ID());
		
		
		sendProcessCompletedEmail(client, user.getEMail(), status, message);
		
	}
	
	private void sendProcessCompletedEmail(MClient client, String email,String status, String message) {
		
		String statusDesc = "Correcta";
		
		if (status.equalsIgnoreCase(MNicProcessCaller.STATUS_Failed)) {
			statusDesc = "Fallida";
		}
		
		String title = "Proceso de llamadas automáticas".concat(" - Ejecución " ).concat(statusDesc);
		
		
		client.sendEMail(email, title, message, null, true);
	}
	
	private String getValueFromConfig(String configName) {
		
		String whereClause = String.format("%s = ? and %s = 'Y'", MSysConfig.COLUMNNAME_Name, MSysConfig.COLUMNNAME_IsActive);
		
		MSysConfig config = new Query(Env.getCtx(), MSysConfig.Table_Name, whereClause, null)
				.setParameters(configName) // REGEX PASSWORD RULES
				.first();
		
		
		if (config != null) {
			return config.getValue();
		}
		else {
			return "";
		}
	}
}
